//
//  GSLayer+Autohinting.h
//  GlyphsCore
//
//  Created by Georg Seifert on 30/03/16.
//  Copyright © 2016 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSLayer.h>

@class GSNode;

@interface GSLayer (Autohinting)

- (BOOL)autohintError:(NSError **)error;
- (BOOL)autohint;
- (NSArray *)getAutohintsDoHorizontal:(BOOL)doHorizontal doVertical:(BOOL)doVertical error:(out NSError **)error;

- (NSArray *)hintsFromCharString:(NSString *)result doLinks:(BOOL)doLinks;
- (NSArray *)hintsFromCharString:(NSString *)result doLinks:(BOOL)doLinks ignoreVerticalStems:(BOOL)ignoreVerticalStems;

- (NSIndexPath *)indexPathOfNodeAtX:(CGFloat)X actualPosition:(NSPoint *)pos;
- (NSIndexPath *)indexPathOfNodeAtY:(CGFloat)Y actualPosition:(NSPoint *)pos;

@end
